"""

// ------------------------------------------------- //

//                                                   //

//            **Copy_files_L :**                     //

//      Extract files from a directory tree          //

//          to a single folder                       //

//                                                   //

// ------------------------------------------------- //

// **Original algorithm :**                          //

//   Sergio  PROA CORONADO, Childerick SEVERAC,      //

//   Etienne DAGUE, Adrian MARTINEZ RIVAS            //

//                                                   //

// **Program developer :**                           //

//   Sergio  PROA CORONADO                           //

// ------------------------------------------------- //



## Purpose:

This program extract files from a directory to a single directory.



## Copyrights (C) 2019-2020 CNRS (France) and IPN (Mexico)



## License:

Automatip_scan is a free software: you can redistribute it and/or modify

it under the terms of the GNU General Public License as published by

the Free Software Foundation, either version 3 of the License, or

(at your option) any later version. https://www.gnu.org/licenses/gpl-3.0.en.html  



"""



# Version : 2019-11-05-11h

import os

import shutil

# path where the files are stored

path = '/Documents/Experiement/Results/PATH/TO/YOUR/DATA/' #exemple 

Fullpath = os.environ['HOME'] + path

# path to the single folder where the files are going to be copied

dst_dir = '/Documents/Experiments/Results/PATH/TO/STORE/ALL/FORCE/CURVES/'  #exemple

dst_path = os.environ["HOME"] + dst_dir

#variables to store folder names, and file names

lFiles = []

lRFiles = []

TWells = 0

con = 0

# lDir stores the complete directory tree

lDir = os.walk(Fullpath)

# root is a string, is the path to the directory. 

# dirs is a list with all the names of the subdirectories. 

# files is the list of all non-directories files

for root,dirs,files in lDir:

	for directory in files:

		(nameDirectory, extention) = os.path.splitext(directory)

		# This line guarantees that only the files with a specific extention are located

		# inside the directory tree 

		if extention == ".jpk-force":

			#This line generates a list with the path to the files, including file

		 	#names and extentions

			lFiles.append(root + '/' + nameDirectory + extention)



# Every force curve has an identifier (for example Well01) which helps knowing from which part of

# the cell has been taken. However this identifier repeats itself every time the area is changed.

# To prevent overwritten files the name must change according to the total number of force curves

# These variables store the part of the string inside the list lFiles that contains the identifier

# and preserve the directory strucutre 

iniS = lFiles[0].find('Cell')

finS = lFiles[0].find('-', iniS) + 1

direc = lFiles[0][iniS:finS]



# Generates a new list that will contain the directory tree path and the filename. However, the

# identifier in the filename will be changed and enumerated accordingly to the total number of 

# force curves files

for ele in lFiles:

	iniFn = ele.find('force-save')

	Fname = ele[iniFn:]

	

	if direc != ele[iniS:finS]:

		iniS = ele.find('Cell')

		finS = ele.find('-', iniS) + 1

		direc = ele[iniS:finS]

		TWells += 1

	sufix = 'Cell' + str(TWells)

	lRFiles.append(dst_path + sufix + '-' + Fname)



# copy the files from its original source (lFiles) to a new path (lRFiles). The files are renamed 

# at the same time they are copied

for ele in range(len(lFiles)):

	shutil.copy( lFiles[ele], lRFiles[ele])

print ('Done')

