# -*- coding: utf-8 -*-
"""
WellDefine v1.0 Define area of each well in the video

Copyright (C) 2019  Fernan R Perez Galvez

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
    
Created on Thu Dec  26 2019

NOTE: before running this script be sure to open in an integrated Developer
Environment of your preference (here tested on Spyder with Pyhton 3.7).

NOTE: Please be sure to have the required libraries installed before running
the script.

#
# WellDefine version 1.0
# PART 2/3
#
# Description: Define area of each well in the video
#

INPUT:
    -image JPG with the first frame of the video
OUTPUT:
    -printed list of regions of interest in console

Step1. Indicate name of the first frame image from previous script.
Step2. Indicate name of CSV file for data logging.

RUN SCRIPT

Step 3. For each well
    -click the extreme left corner of the area of interest
    -drag to the right lower corner
    -release click
    -Press 'c' on keyboard twice for next well

Step 4. Copy the printed list named 'pozos'

"""

import cv2
import pandas as pd

# initialize the well column/row list

nombres = ['a1', 'a2','a3','a4','a5','a6','a7','a8','a9', 'a10','a11','a12',
           'b1','b2','b3','b4','b5','b6','b7','b8','b9','b10','b11','b12',
           'c1','c2','c3','c4','c5','c6','c7','c8','c9','c10','c11','c12',
           'd1','d2','d3','d4','d5','d6','d7','d8','d9','d10','d11','d12',
           'e1','e2','e3','e4','e5','e6','e7','e8','e9','e10','e11','e12',
           'f1','f2','f3','f4','f5','f6','f7','f8','f9','f10','f11','f12',
           'g1','g2','g3', 'g4','g5','g6','g7','g8','g9','g10','g11','g12']

# now let's initialize the list of reference point 
ref_point = [] 
crop = False
pozos = []
  
def shape_selection(event, x, y, flags, param): 
    # grab references to the global variables 
    global ref_point, crop 
  
    # if the left mouse button was clicked, record the starting 
    # (x, y) coordinates and indicate that cropping is being performed 
    if event == cv2.EVENT_LBUTTONDOWN: 
        ref_point = [(x, y)] 
  
    # check to see if the left mouse button was released 
    elif event == cv2.EVENT_LBUTTONUP: 
        # record the ending (x, y) coordinates and indicate that 
        # the cropping operation is finished 
        ref_point.append((x, y)) 
  
        # draw a rectangle around the region of interest 
        cv2.rectangle(image, ref_point[0], ref_point[1], (0, 255, 0), 2) 
        cv2.imshow("image", image)
  
  
# read first frame image
image = cv2.imread("frame-yourVideoName.jpg")       # HERE Step 1

clone = image.copy() 
cv2.namedWindow("image") 
cv2.setMouseCallback("image", shape_selection)

# run for all cases
for i in nombres:
    
    aiuda = "Well {} Well {}"
    print(aiuda.format(i, "1"))
    # inform of the well to be selected

    # keep looping until the 'c' key is pressed 
    while True: 
        # display the image and wait for a keypress 
        cv2.imshow("image", image) 
        key = cv2.waitKey(1) & 0xFF
      
        # press 'r' to reset the window 
        if key == ord("r"): 
            image = clone.copy()
      
        # if the 'c' key is pressed, break from the loop 
        elif key == ord("c"): 
            break

    if len(ref_point) == 2: 
        pozos.append(ref_point)
        print("saved, next well...") 
    
        cv2.waitKey(0)

# close all open windows 
cv2.destroyAllWindows()

# record data
wells = []
wells = pd.DataFrame.from_records(pozos, columns =[('x1,y1'),('x2,y2')])
wells['names'] = nombres
wells.to_csv('wells-yourVideoName.csv')             # HERE Step 2

print(pozos)
