# -*- coding: utf-8 -*-
"""
FirstFrame v1.0 Extract first frame of video file to define well regions

Copyright (C) 2019  Fernan R Perez Galvez

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
    
Created on Thu Dec  26 2019

NOTE: before running this script be sure to open in an integrated Developer
Environment of your preference (here tested on Spyder with Pyhton 3.7).

NOTE: Please be sure to have the required libraries installed before running
the script.

#
# FirstFrame version 1.0
# PART 1/3
#
# Description: Extract first frame of video file to define well regions
#

INPUT:
    -video file (MP4, WMV)
OUTPUT:
    -image JPG with the first frame of the video

Step1. Indicate name for the output image.
Step2. Indicate name and location of video file.

RUN SCRIPT

"""


# Program To Read video 
# and Extract Frames 
import cv2 
  
# Function to extract frames 
def FrameCapture(path): 
      
    # Path to video file 
    vidObj = cv2.VideoCapture(path) 
  
  
    # checks whether frames were extracted 
    success = 1
  
    while success: 
  
        # vidObj object calls read 
        # function extract frames 
        success, image = vidObj.read() 
  
        # Saves the frames with frame-count 
        cv2.imwrite("frame-yourVideoName.jpg", image)    # HERE STEP 1
  
        break
  
# Driver Code 
if __name__ == '__main__': 
  
    # Calling the function 
    FrameCapture("yourLocation\yourVideoName.mp4") # HERE STEP 2
