function [x, y, z] = LocateCraniotomy(dicom)
% LocateCraniotomy guide userinput to return 3D coordinates of craniotomy
% center
% =========================================================================
% AUTHOR       Zachary Ip
% CONTACT      ipzach@uw.edu
% INSTITUTION  University of Washington
% DATE        25th November 2019
% 
% INPUTS dicom - 3D double,single, uint - 3D MRI data
%   
% OUTPUTS x,y,z - int - coordinates of craniotomy center
% =========================================================================
disp('Do you already know the coordinates for the center the craniotomy? (y)es or (n)o')
ui = input('','s');
if ui == 'y'
    disp('Please enter the coordinates')
    ui = input('x = ','s');
    x = round(str2num(ui));
    ui = input('y = ','s');
    y = round(str2num(ui));
    ui = input('z = ','s');
    z = round(str2num(ui));
    frame = z;
else
    disp('Select which slice you would like to center the craniotomy on by using the (f)orward or (b)ackward')
    disp('Enter (y) when finished.')
    frame = 1;
    ui = 'null';
    while ui ~= 'y'
        imshow(dicom(:,:,frame),[]), truesize([600 600]);title(['zFrame=' num2str(frame)]);
        hold on
        ui = input(' ','s');
        if ui == 'f'
            frame = frame+1;
        elseif ui =='b'
            frame = frame-1;
        end % if
    end % while
    
end % else
disp('Now select on the skull where you would like the craniotomy centered')
disp('Hit "Enter" after making your selction')
[y, x] = getpts;
 
x = round(x);
y = round(y);
 
z = frame;
 
disp('The coordinates for the center of the craniotomy are:')
disp(['x = ',num2str(x)])
disp(['y = ',num2str(y)])
disp(['z = ',num2str(z)])
end % LocateCraniotomy