function [craniotomyMask] = Craniotomy(mask,x,y,z,radius,X,Y,Z, resolution)
% Craniotomy Remove spherical region from mask of variable size
% =========================================================================
% AUTHOR       Zachary Ip
% CONTACT      ipzach@uw.edu
% INSTITUTION  University of Washington
% DATE        25th November 2019
% 
% INPUTS mask - 3D double - mask of skull
%        x,y,x - int - center point of craniotomy
%        radius - double - radius of craniotomy (in mm)
%        X, Y, Z - 3D double - grid vectors of skull mask
%        resolution - double - voxel-to-mm conversion
% =========================================================================
sphere_center = [x y z];
radius = radius/resolution;
 
ball = mask.*0;
ball((X-sphere_center(1)).^2 + (Y-sphere_center(2)).^2 + ((Z-sphere_center(3))).^2 <= radius.^2) = 1;
 
craniotomyMask = mask - ball;
craniotomyMask(craniotomyMask<0)=0;
 
% ui = input('Would you like a second, outer radius? (y)es or (n)o: ','s');
% if ui == 'y'
%     rad2 = [];
%     while(isempty(rad2) || rad2<rad)
%         disp(' ')
%         rad2 = input('Please enter the outer radius in mm and press enter: '); % Example value: 25
%     end
%     
%     radius = rad2/xsize;%desired radius (mm) / distance between pixels (mm/pix)
%  
%     ball = crani.*0;
%     ball((X-sphere_center(1)).^2 + (Y-sphere_center(2)).^2 + ((Z-sphere_center(3)).*scaler).^2 >= radius.^2) = 1;
%  
%     crani = crani - ball;
%     crani(crani<0)=0;
% end
end % function