function [scaledMask,X,Y,Z] = ScaleMask(mask, scaler, dimension)
% ScaleMask interpolate values along a single dimension
% =========================================================================
% AUTHOR       Zachary Ip
% CONTACT      ipzach@uw.edu
% INSTITUTION  University of Washington
% DATE        25th November 2019
% 
% INPUTS mask - 3D double - mask to be scaled
%        scaler - int - amount to scale by
%        dimension - int - dimension in which to scale mask
%   
% OUTPUTS scaledMask - 3D double - scaled mask
%         X, Y, Z - 3D double - grid vectors of scaled mask
% =========================================================================
% ensure valid dimensional input
valid = [1 2 3];
filledMask = zeros(size(mask));
if ~ismember(dimension, valid)
    error('Please enter an integer between 1 and 3 for dimension')
end
scaler = ceil(scaler);
switch dimension
    case 1
        for n = 1:scaler
            mask = cat(1,mask,mask.*0);
        end % n
    case 2
        for n = 1:scaler
            mask = cat(2,mask,mask.*0);
        end % n
    case 3
        for n = 1:scaler
            mask = cat(3,mask,mask.*0);
        end % n
end % switch
[X,Y,Z] = ndgrid(0:size(mask,1)-1, 0:size(mask,2)-1, (0:(size(mask,3)-1)));
interpolatedMask = griddedInterpolant(X,Y,Z.*scaler,mask);
scaledMask = interpolatedMask(X,Y,Z);
end % function