function [mergedMask] = MergeMasks(varargin)
% MergMasks combine masks 
% =========================================================================
% AUTHOR       Zachary Ip
% CONTACT      ipzach@uw.edu
% INSTITUTION  University of Washington
% DATE        25th November 2019
% 
% INPUTS varying - cells of 3D double - binary masks to be combined
%   
% OUTPUTS cleanMask - 3D double - combined mask
% =========================================================================
mergedMask = varargin{1};
for i = 1:nargin
    mergedMask = mergedMask + varargin{i};
end % i
mergedMask(mergedMask > 1) = 1;
end