#!/bin/tcsh  

setenv SCRIPTS_HOME `pwd`    # please change `pwd` to the location of the scripts such as /home/$USER/bin
setenv SCRIPTS `pwd`    # please change `pwd` to the location of the scripts such as /home/$USER/bin

alias thermo 'perl $SCRIPTS/thermo.pl \!^ 1 | grep "^[1-9]" | awk '\''{printf "%3.3f\t%3.3f\t%3.3f\t", $5, $9, $10} END {printf "\n" }'\'' '
alias ZPVE 'perl $SCRIPTS/thermo.pl \!^ 1 | grep zero | awk '\''{printf "%3.3f \t", $10}'\'' '

if ( $#argv != 1 ) then
   echo "Error in the number of arguments passed.\n"
   echo "Usage: run-thermo.csh <unique-str-file>"
   echo "   Eg: run-thermo.csh uniqueStructures-pw91.data"
   exit
endif

foreach FILE (`cat $1 | awk -F"-pw91" '{print $1}'`)
   if ( -e o$FILE.xyz ) then
      else
      babel -ig09 $FILE-pw91.log -oxyz > o$FILE-pw91.xyz
   endif
   @ sym = `$SCRIPTS_HOME/calcSymmetry.csh o$FILE-pw91.xyz | grep "It seems to be" |sed "s/[a-zA-Z]//g" | awk '{if(NF==0){print 1} else {print $1}}'`
   $SCRIPTS_HOME/make-thermo-gaussian.csh o$FILE-pw91.xyz $FILE-pw91.log $FILE-thermo.inp $sym
end

foreach FILE (`cat $1 | awk -F"-pw91" '{print $1}'`)
  setenv E `gaussianE.csh pw91 last $FILE-pw91.log | awk '{print $2}' | bc `
  printf "%s\t" "$FILE "
  printf "%4.10f\t" $E
  printf "%4.4f\t" `ZPVE $FILE-thermo.inp`
  thermo $FILE-thermo.inp
end

