# -*- coding: utf-8 -*-
"""
Created on Thu Jan 16 11:29:14 2020

@author: fst
"""

# <codecell>
import numpy as np
import h5py,glob

# <codecell>

def Geometry(FileName):
    
    isValid=1
    Data=np.nan
    Flag=np.nan
    GeoSC=np.zeros(2)
    GeoSun=np.zeros(2)
    
    
    try:
        File=h5py.File(FileName,'r')
    except:
        isValid=0
    
    if isValid:
        if len(File.keys())<10:
            isValid=0
            File.close()
        
    if isValid:
        Keys=list(File.keys())
    
        Lat2D=np.copy(File[Keys[0]]['Geolocation']['Earth']['Latitude'])
        Lon2D=np.copy(File[Keys[0]]['Geolocation']['Earth']['Longitude'])
        Lat=Lat2D.reshape(-1)
        Lon=Lon2D.reshape(-1)
        SCZen=np.copy(File[Keys[0]]['Geolocation']['Earth']['ViewAngleZenith'])
        SunZen=np.copy(File[Keys[0]]['Geolocation']['Earth']['SunAngleZenith'])
        
        Pos=np.argmin(SCZen)
        GeoSC[0]=Lat[Pos]
        GeoSC[1]=Lon[Pos]
        Pos=np.argmin(SunZen)
        GeoSun[0]=Lat[Pos]
        GeoSun[1]=Lon[Pos]
        
        Flag=0
        File.close()
        
    return Data,Flag,GeoSC,GeoSun

# <codecell>

if __name__=='__main__':
    
    FileList=[]
    for Year in ['2016','2017']:
        for Month in range(1,13,1):
            List=glob.glob('/net/ganesha/raid05/rls/DSCOVR_EPIC_L1B_V2/'+Year+'/'+str(Month).zfill(2)+'/*.h5')
            for iFile in range(len(List)):
                FileList.append(List[iFile])
    
    FileList.sort()
    
    SaveFile=open('Geometry.csv','w')
    
    SaveFile.write('Time,SubObs_Lat,SubObs_Lon,SubStar_Lat,SubStar_Lon\n')
    
    for iFile in range(len(FileList)):
        FileName=FileList[iFile]
        if iFile%100==0:
            print(FileName)
        
        Data,Flag,GeoSC,GeoSun=Geometry(FileName)
        
        if np.isnan(Flag):
            continue
        
        SaveFile.write(str(FileName[-20:-6])+',')
        SaveFile.write(str(GeoSC[0])+',')
        SaveFile.write(str(GeoSC[1])+',')
        SaveFile.write(str(GeoSun[0])+',')
        SaveFile.write(str(GeoSun[1])+'\n')
        
    SaveFile.close()