# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 20:21:11 2020

@author: fst
"""

# <codecell>
import numpy as np
import matplotlib.pyplot as plt
import healpy as hp
import os

# <codecell>

if __name__=='__main__':
    
    if not os.path.isdir('Weight'):
        os.mkdir('Weight')
    
    NPZ=np.load('W.npz',allow_pickle=True)
    W=NPZ['W']
    Time=NPZ['Time']

    for iTime in range(Time.size):
        print(Time[iTime])
        hp.visufunc.mollview(W[iTime],flip='geo',cmap='brg',min=0,max=0.002,title=Time[iTime].strftime('%Y%m%d%H%M%S'))
        hp.graticule()
    
        plt.savefig('Weight/'+Time[iTime].strftime('%Y%m%d%H%M%S')+'.png')
        plt.close()