# -*- coding: utf-8 -*-
"""
Created on Thu Jan 16 16:33:56 2020

@author: fst
"""

# <codecell>
import numpy as np
import datetime
import matplotlib.pyplot as plt
import sys

# <codecell>

def MakeTSPlot(FileName,LCName):

    LightCurve=np.genfromtxt(FileName+'.csv',delimiter=',',skip_header=1)
    
    File=open(FileName+'.csv','r')
    Header=File.__next__().strip('\n').split(',')
    File.close()
    
    TimeArr=np.array([],dtype=object)
    for Time in LightCurve[:,0]:
        TimeArr=np.append(TimeArr,datetime.datetime.strptime(str(int(Time)),'%Y%m%d%H%M%S'))
    
    nPlot=LightCurve.shape[1]-1
    Fig,Ax=plt.subplots(nrows=(nPlot+1)//2,ncols=2,figsize=(12,2*((nPlot+1)//2)))
    for iPlot in range(nPlot):
        AxTemp=Ax[iPlot//2,iPlot%2]
        AxTemp.plot(TimeArr,LightCurve[:,iPlot+1],'.b',ms=1)
        AxTemp.axhline(np.mean(LightCurve[:,iPlot+1]),ls='--',lw=1.5,c='k')
        AxTemp.set_title('('+chr(ord('a')+iPlot)+') '+Header[iPlot+1],fontsize=15)
        AxTemp.tick_params(labelsize=15)
        Lim=np.array([2*np.percentile(LightCurve[:,iPlot+1],10)-np.percentile(LightCurve[:,iPlot+1],90),
                      2*np.percentile(LightCurve[:,iPlot+1],90)-np.percentile(LightCurve[:,iPlot+1],10)])
        AxTemp.set_ylim(Lim[0],Lim[1])
        
        if iPlot%2==0:
            AxTemp.set_ylabel(LCName,fontsize=15)
        if iPlot>=nPlot-2:
            AxTemp.tick_params(axis='x',labelrotation=30)
        else:
            AxTemp.xaxis.set_ticklabels([])
    
    Fig.tight_layout()
    Fig.savefig(FileName+'.png')    

# <codecell>

if __name__=='__main__':

    if sys.argv[1]=='LightCurve':
        MakeTSPlot('LightCurve',r'$R_k$')
    elif sys.argv[1]=='Geometry':
        MakeTSPlot('Geometry','Degree')
    elif sys.argv[1]=='NormalizedLightCurve':
        MakeTSPlot('NormalizedLightCurve',r"$R_k'$")
    elif sys.argv[1]=='U':
        MakeTSPlot('U',r'$u_j$')
    else:
        print('Invalid input')
        
    plt.show()