# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 16:08:11 2020

@author: fst
"""

# <codecell>
import numpy as np
import matplotlib.pyplot as plt

# <codecell>

def MakePCPlot(FileName,LCName):

    Spectrum=np.genfromtxt(FileName+'.csv',delimiter=',',skip_header=1)
    
    File=open(FileName+'.csv','r')
    Header=File.__next__().strip('\n').split(',')
    File.close()
    Wavelength=np.zeros(len(Header)-1)
    for iWave in range(Wavelength.size):
        Wavelength[iWave]=float(Header[iWave+1][:-2])
    
    nPlot=Spectrum.shape[0]
    Fig,Ax=plt.subplots(nrows=(nPlot+1)//2,ncols=2,figsize=(12,2*((nPlot+1)//2)))
    for iPlot in range(nPlot):
        AxTemp=Ax[iPlot//2,iPlot%2]
        AxTemp.plot(Wavelength,Spectrum[iPlot,1:],'.-b',ms=10.,lw=2.5)
        AxTemp.axhline(0,ls='--',lw=1.5,c='k')
        AxTemp.set_title('('+chr(ord('a')+iPlot)+') PC_'+str(iPlot+1),fontsize=15)
        AxTemp.tick_params(labelsize=15)        
        
        if iPlot%2==0:
            AxTemp.set_ylabel(LCName,fontsize=15)
        if iPlot>=nPlot-2:
            AxTemp.set_xlabel('Wavelength ['+Header[-1][-2:]+']',fontsize=15)
        else:
            AxTemp.xaxis.set_ticklabels([])
    
    Fig.tight_layout()
    Fig.savefig(FileName+'.png')

def MakeSVPlot(FileName):
    Sigma=np.genfromtxt(FileName+'.csv',delimiter=',')
    plt.figure(figsize=(12,8))
    plt.plot(np.arange(Sigma.size)+1,Sigma,'.-b',ms=10.,lw=2.5)
    plt.tick_params(labelsize=20)
    plt.xlabel('PC Index',fontsize=20)
    plt.ylabel('Singular Value',fontsize=20)
    plt.savefig('SingularValue.png')

# <codecell>

if __name__=='__main__':

    MakePCPlot('V_T',r'$v_j$')
    MakeSVPlot('SingularValue')
    
    plt.show()