# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 18:56:07 2020

@author: fst
"""

# <codecell>
import numpy as np
import matplotlib.pyplot as plt

# <codecell>

def MakePGPlot(FileName):

    TimeSeries=np.genfromtxt(FileName+'.csv',delimiter=',',skip_header=1)
    
    File=open(FileName+'.csv','r')
    Header=File.__next__().strip('\n').split(',')
    File.close()
    
    nPlot=TimeSeries.shape[1]-1
    Fig,Ax=plt.subplots(nrows=(nPlot+1)//2,ncols=2,figsize=(12,2*((nPlot+1)//2)))
    for iPlot in range(nPlot):
        AxTemp=Ax[iPlot//2,iPlot%2]
        
        for Period in [0.5,1.,182.625,365.25]:
            AxTemp.axvline(x=1./Period,ls='--',lw=1.5,c='k')
        
        AxTemp.plot(TimeSeries[:,0],TimeSeries[:,iPlot+1],'-b',lw=1.5)
        #AxTemp.axhline(np.mean(LightCurve[:,iPlot+1]),ls='--',lw=1.5,c='k')
        AxTemp.set_title('('+chr(ord('a')+iPlot)+') '+Header[iPlot+1],fontsize=15)
        AxTemp.tick_params(labelsize=15)
        AxTemp.set_xscale('log')
        AxTemp.set_yscale('log')
        
        if iPlot%2==0:
            AxTemp.set_ylabel('PSD',fontsize=15)
        if iPlot>=nPlot-2:
            AxTemp.set_xlabel(r'Frequency [$day^{-1}$]',fontsize=15)
        else:
            AxTemp.xaxis.set_ticklabels([])
    
    Fig.tight_layout()
    Fig.savefig(FileName+'.png')    

# <codecell>

if __name__=='__main__':
    
    MakePGPlot('Periodogram')
    
    plt.show()