# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 21:41:30 2020

@author: fst
"""

# <codecell>
import numpy as np
import matplotlib.pyplot as plt
import healpy as hp

# <codecell>

if __name__=='__main__':
    
    PixelValue=np.genfromtxt('PixelValue.csv',delimiter=',',skip_header=1)
    File=open('PixelValue.csv','r')
    Header=File.__next__().strip('\n').split(',')
    Header=np.array(Header).astype(float).astype(int).astype(str)
    File.close()
    
    for iReg in range(PixelValue.shape[1]):
        hp.visufunc.mollview(PixelValue[:,iReg],min=-0.05,max=0.05,flip='geo',cmap='brg',title=r'$\lambda=10^{'+Header[iReg]+'}$')
        hp.graticule()
    
        plt.savefig('Map_'+Header[iReg]+'.png')
    
    plt.show()