# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 23:39:36 2020

@author: fst
"""

# <codecell>
import numpy as np
import matplotlib.pyplot as plt
import healpy as hp

# <codecell>

if __name__=='__main__':
    
    Covariance=np.load('Covariance.npz',allow_pickle=True)['Covariance']
    
    plt.figure(0,(12,8))
    plt.imshow(Covariance,cmap='brg',vmin=-2e-6,vmax=2e-6)
    plt.tick_params(labelsize=20)
    plt.xlabel('Pixel Index',fontsize=20)
    plt.ylabel('Pixel Index',fontsize=20)
    Cb=plt.colorbar(format='%5.1e')
    Cb.ax.tick_params(labelsize=20)
    Cb.set_label('Covariance Coefficient',fontsize=20,rotation=270,labelpad=20)
    plt.savefig('Covariance.png')

    Uncertainty=np.sqrt(Covariance.diagonal())
    hp.visufunc.mollview(Uncertainty.reshape(-1),flip='geo',cmap='brg',format='%5.1e',min=2.5e-3,max=4.5e-3,title='')
    hp.graticule()
        
    plt.savefig('Uncertainty.png')
    
    plt.show()