# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 17:57:24 2020

@author: fst
"""

# <codecell>
import numpy as np
import datetime 
import scipy.signal

# <codecell>

if __name__=='__main__':
    
    TimeSeries=np.genfromtxt('U.csv',delimiter=',',skip_header=1)

    TimeArr=np.array([],dtype=object)
    for Time in TimeSeries[:,0]:
        TimeArr=np.append(TimeArr,datetime.datetime.strptime(str(int(Time)),'%Y%m%d%H%M%S'))
    TimeDif=((TimeArr-TimeArr[0])/datetime.timedelta(days=1)).astype(float)
    
    nFrequency=4001
    Frequency=1./np.power(10,np.linspace(-1.,3.,nFrequency))
    
    Periodogram=np.zeros([nFrequency,TimeSeries.shape[1]])
    Periodogram[:,0]=Frequency
    for iPC in range(TimeSeries.shape[1]-1):
        Periodogram[:,iPC+1]=scipy.signal.lombscargle(TimeDif,TimeSeries[:,iPC+1],Frequency*2*np.pi)
        
    SaveHeader='Frequency [day-1]'
    for iPC in range(TimeSeries.shape[1]-1):
        SaveHeader+=',PC_'+str(iPC+1)
        
    np.savetxt('Periodogram.csv',Periodogram,delimiter=',',header=SaveHeader,comments='')