# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 23:19:57 2020

@author: fst
"""

# <codecell>
import numpy as np

# <codecell>

if __name__=='__main__':
    
    iPC=1
    iReg=1
    Lambda=1e-3
    
    U=np.genfromtxt('U.csv',delimiter=',',skip_header=1)[:,iPC+1].reshape(-1,1)
    P=np.genfromtxt('PixelValue.csv',delimiter=',',skip_header=1)[:,iReg].reshape(-1,1)
    
    NPZ=np.load('W.npz',allow_pickle=True)
    W=NPZ['W']
    
    Residual=U-np.matmul(W,P)
    Variance=(np.matmul(Residual.T,Residual)/(U.size-P.size))[0][0]
    
    InvMat=np.linalg.inv(np.matmul(W.T,W)+Lambda*np.identity(W.shape[1]))
    Covariance=Variance*np.matmul(np.matmul(InvMat,np.matmul(W.T,W)),InvMat)
    
    np.savez_compressed('Covariance.npz',Covariance=Covariance)