# -*- coding: utf-8 -*-
"""
Created on Fri Jan 17 19:57:56 2020

@author: fst
"""

# <codecell>
import numpy as np
import datetime
import healpy as hp

# <codecell>

if __name__=='__main__':
    
    Geometry=np.genfromtxt('Geometry.csv',delimiter=',',skip_header=1)
    
    TimeArr=np.array([],dtype=object)
    for Time in Geometry[:,0]:
        TimeArr=np.append(TimeArr,datetime.datetime.strptime(str(int(Time)),'%Y%m%d%H%M%S'))
    
    NSide=2**4
    NPix=hp.nside2npix(NSide)
    D2R=np.pi/180
    
    W=np.ones([Geometry.shape[0],NPix])
    
    PixLon,PixLat=hp.pixelfunc.pix2ang(NSide,np.arange(NPix,dtype=int),lonlat=True)
    
    for iTime in range(Geometry.shape[0]):
        
        ObsLat=Geometry[iTime,1]
        ObsLon=Geometry[iTime,2]
        
        VectX=np.cos(PixLat*D2R)*np.cos((PixLon-ObsLon)*D2R)-np.cos(ObsLat*D2R)    
        VectY=np.cos(PixLat*D2R)*np.sin((PixLon-ObsLon)*D2R)
        VectZ=np.sin(PixLat*D2R)-np.sin(ObsLat*D2R)
        Dist=np.sqrt(VectX**2+VectY**2+VectZ**2)
        
        CosObs=np.cos(np.arcsin(Dist/2)*2)
        Pos=np.where(CosObs<0)[0]
        CosObs[Pos]=0
        W[iTime,:]*=CosObs
        
        SunLat=Geometry[iTime,3]
        SunLon=Geometry[iTime,4]
        
        VectX=np.cos(PixLat*D2R)*np.cos((PixLon-SunLon)*D2R)-np.cos(SunLat*D2R)    
        VectY=np.cos(PixLat*D2R)*np.sin((PixLon-SunLon)*D2R)
        VectZ=np.sin(PixLat*D2R)-np.sin(SunLat*D2R)
        Dist=np.sqrt(VectX**2+VectY**2+VectZ**2)
        
        CosSun=np.cos(np.arcsin(Dist/2)*2)
        Pos=np.where(CosSun<0)[0]
        CosSun[Pos]=0
        W[iTime,:]*=CosSun
        
    W=W/np.sum(W,axis=1).reshape(-1,1)
    
    np.savez_compressed('W.npz',W=W,Time=TimeArr)