###
#This file contains R script to reconstruct figures 2A and 2B from Krasovec et al. 2019.
#the ggplot2 and dplyr packages will need to be installed if not already present (e.g. using the following line without the # at the start:
#install.packages(c("ggplot2", "dplyr"))

#Set the working directory by adjusting this line to indicate the folder containing the data and removing the # at the beginning:
#setwd("/Path/to/folder")
#the code may be run all together, or bit by bit from an R terminal

library(ggplot2)
library("dplyr")

##create the Figure 2A
# read in the data
d2A <- read.delim("Krasovec_etal_JoVE_data.txt") %>%
  subset(figure=="2A")

# create the figure 
p1 <- ggplot(aes(x = replicate, y = mutation_rate,  colour = marker, shape = genotype), data=d2A)
pdf("Figure_2A.pdf",width=4, height=4.4)
p1 + 
  scale_y_log10(expression(paste("Mutation rate (10"^-9, "generation"^-1,")")), breaks=c(0.4,1,5,30,200), limit=c(0.05, 300))  + 
  scale_x_discrete(expression(paste("glucose"))) +
  scale_color_manual(values=c("#000A44","#660000","#35A2AD"), guide=FALSE) +
  scale_shape_manual(values=c(19,17), guide=FALSE) +
  facet_grid(~glucose, scales="free_x") +
  geom_errorbar(aes(ymin=mutation_rate_lower, ymax=mutation_rate_upper), width=0.2) +
  geom_point(alpha=0.8, size=6) +
  theme_classic(base_size = 14) +
  theme(axis.line.x = element_line(size=1), 
        axis.line.y = element_line(size=1), 
        axis.ticks=element_line(size=2), 
        axis.text.x=element_text(size=12, angle=90),
        axis.text.y=element_text(size=12) ) 
graphics.off()


##create the Figure 2B
# read in the data
d2B <- read.delim("Krasovec_etal_JoVE_data.txt") %>%
  subset(figure=="2B")

#create the figure
p2 <- ggplot(aes(x = replicate, y = mutation_rate,  colour = marker, shape = genotype), data=d2B)
pdf("Figure_2B.pdf",width=4, height=4.4)
p2 + 
  scale_y_log10(expression(paste("Mutation rate (10"^-9, "generation"^-1,")")), breaks=c(0.4,1,5,30,200), limit=c(0.05, 300))  + 
  scale_x_discrete(expression(paste("glucose"))) +
  scale_color_manual(values=c("#660000"), guide=FALSE) +
  scale_shape_manual(values=c(17), guide=FALSE) +
  facet_grid(~glucose, scales="free_x") +
  geom_errorbar(aes(ymin=mutation_rate_lower, ymax=mutation_rate_upper), width=0.2) +
  geom_point(alpha=0.8, size=6) +
  theme_classic(base_size = 14) +
  theme(axis.line.x = element_line(size=1), 
        axis.line.y = element_line(size=1), 
        axis.ticks=element_line(size=2), 
        axis.text.x=element_text(size=12, angle=90), 
        axis.text.y=element_text(size=12) ) 
graphics.off()