#This script, when run in R, will generate a pdf file containing a layout for a 96-well plate, distributing the cultures for 5 fluctuation assay (represented by 5 different colours) randomly across the plate.

#Three random wells from each fluctuation assay are highlighted for use in estimating the number of cells (Nt)

#printing out in colour at 100% size (i.e. do not scale to fit the page) should allow the layout to be seen through each well of a standard 96-well plate.

#the pdf file is named layout.pdf and saved in the current working directory. By default this is the user's home directory, but may be set by modifying the following line and removing the initial # symbol

#setwd("/path/to/directory/of/choice")

#If this file is in the current working directory, having installed R (www.r-project.org) it may be run simply by typing the following at the R command line, without the initial # symbol: 

# source("LayoutGenerator.R") 

ifelse(require(ggplot2), yes = library(ggplot2), no = install.packages("ggplot2"))

treatment <- factor(c(rep("first", 20), rep("second", 19), rep("third", 19), rep("fourth", 19), rep("fifth", 19)), levels = c("first", "second", "third", "fourth", "fifth"))

NtWells <- factor(c(rep("NtWell", 3), rep("fluctuation", 17),rep(c(rep("NtWell", 3), rep("fluctuation", 16)),4)), levels = c("NtWell", "fluctuation"))
  
  df <- data.frame(treatment, NtWells)
  df <- df[sample(nrow(df)),]
  
  rows <- factor(rep(LETTERS[1:8], 12), levels = rev(LETTERS[1:8]))
  cols <- rep(1:12, each = 8)
  
  df <- cbind(rows, cols, df)
  
  ggplot(df, aes(x = cols, y = rows, colour = NtWells, fill = treatment))+
    scale_colour_manual(values = c("black","white"))+
    scale_fill_brewer(palette = "Set1")+
    geom_point(shape=21, size = 5, stroke = 2) +
    scale_x_continuous(breaks = 1:12, position = "top")+
    theme_classic()
  
  ggsave("layout.pdf", width = 152, height =88, units = "mm")
