function [bodyparts,parts_loc,p] = read_DLC_csv(fname)
% function to read in a csv file generated by deepLabCut
% DLC format:
%   row 1: "scorer" followed by a scorer label in each column
%   row 2: "bodyparts" followed by the same label in 3 consecutive columns
%       before switching to a new bodypart label
%
% INPUTS:
%   fname - name of .csv file containing x,y,likelihood data from
%       deeplabcut
%
% OUTPUTS:
%   bodyparts - cell array containing strings describing the labeled body
%       parts
%   parts_loc - m x n x 2 array where m is the number of body parts, n is
%       the number of frames in the video. each bodypart-frame entry is an
%       x,y coordinate pair
%   p - m x n array where m is the number of body parts, and n is
%       the number of frames in the video. contains the likelihood score
%       from DeepLabCut. A likelihood of 1 appears to indicate high
%       confidence, 0 is low confidence


numHeaderLines = 3;

fid = fopen(fname,'r');

% read first two lines into a string
temp = textscan(fid,'%s',2,'Delimiter','\n');
bodyparts = textscan(temp{1}{2},'%s','delimiter',',');
bodyparts = {bodyparts{1}{2:end}};
bodyparts = unique(bodyparts,'stable');   % 'stable' keeps the unique function from sorting the results

fclose(fid);

num_bodyparts = length(bodyparts);

% assume variables are stored as x,y,likelihood; may need modification if
% DLC version changes the way data are stored

csvData = csvread(fname, numHeaderLines, 1);
numFrames = size(csvData,1);

parts_loc = zeros(num_bodyparts, numFrames, 2);
p = zeros(num_bodyparts,numFrames);

for i_bodypart = 1 : num_bodyparts
    xCol = i_bodypart*3 - 2;
    yCol = i_bodypart*3 - 1;
    pCol = i_bodypart*3;
    parts_loc(i_bodypart,:,:) = csvData(:,xCol:yCol); 
    p(i_bodypart,:) = csvData(:,pCol);
end


end