
# this script reads in files with logs and merges them to one big csv file with only the trials of one type 
#(e.g. Tlogs = training trails, VTlogs = thresholding pretest trials, FClog = forced choice trials, EMlog = error monitoring trials) that's ready to be read by R

from os import listdir
import csv



def main():
    for which in range(4):
        fldr = 'log usable' # we are mainly interested in the data from usable participants for our analysis
        if which == 0:
            c1 = 39
            c2 = 214
            headr = ['subjectnr','conditionnr', 'trialnr', 'trialtype', 'itemtype', 'correctanswer', 'key', 'matchmismatch', 'RT', 'sound', 'pic', 'foilpic']
            combfile = 'Tlogsusable.csv'
            nrl = 12
            fldr = 'log usable' # we are mainly interested in the data from usable participants for our analysis
        elif which == 1:
            c1 = 216
            c2 = 235
            headr = ['subjectnr','conditionnr', 'trialnr', 'trialtype', 'itemtype', 'correctanswer', 'key', 'locationcorrectanswer', 'RT', 'totaltime', 'sound', 'pic', 'foilpic']
            combfile = 'VTlogsall.csv'
            nrl = 13
            fldr = 'log all' # however, for the analysis of threshold pretest results we do want logfiles of all participants that made it to the threshold test (122 subjects total)
        elif which == 2:
            c1 = 237
            c2 = 304
            headr = ['subjectnr','conditionnr', 'trialnr', 'trialtype', 'itemtype', 'correctanswer', 'key', 'locationcorrectanswer', 'RT', 'critword', 'wordduringwhichtheypressed', 'totaltime', 'timew1', 'timew2', 'timew3', 'timew4', 'timew5', 'timew6', 'timew7', 'cumtimew1', 'cumtimew2', 'cumtimew3', 'cumtimew4', 'cumtimew5', 'cumtimew6', 'cumtimew7', 'sound', 'pic', 'foilpic']
            combfile = 'FClogsusable.csv'
            nrl = 29
            fldr = 'log usable' # we are mainly interested in the data from usable participants for our analysis
        elif which == 3:
            c1 = 306
            c2 = 431
            nrl = 27
            headr = ['subjectnr','conditionnr', 'trialnr', 'trialtype', 'itemtype', 'correctanswer', 'key', 'wassoundcorrect', 'RT', 'critword', 'wordduringwhichtheypressed', 'totaltime', 'timew1', 'timew2', 'timew3', 'timew4', 'timew5', 'timew6', 'timew7', 'cumtimew1', 'cumtimew2', 'cumtimew3', 'cumtimew4', 'cumtimew5', 'cumtimew6', 'cumtimew7', 'sound']
            combfile = 'EMlogsusable.csv'
            fldr = 'log usable' # we are mainly interested in the data from usable participants for our analysis
        # what folder should it grab the responsesfiles from?
        # it makes a list of all files in that directory
        list = listdir(fldr)
        # sometimes the folder on my computer contains and a file called .DS_store
        # the next three lines of code throw these out
        # BUT IF THOSE WERE NOT THERE IT THROWS OUT RESPONSE FILES
        # SO CHECK WHAT IT PRINTS / whether there's an error and comment/uncomment the next few lines accordingly
        # print list.pop(-1)
        # print list.pop(0)
        # just to check it also prints out the nr of responsesfiles it will combine, make sure this is the 
        # right number (we have 104 usable logs)
        nr = len(list)
        print list, nr
        # it will add all logs to this list
        alllogs = []
        for file in list:
            filename = fldr + '/' + file
            g = open(filename, 'r')
            counter = 0
            for line in g:
                if counter > c1 and counter < c2: # these linenumbers are the relevant lines of the log file for the EM trials
                    # we will put everything from the line into this list
                    minilist = []
                    splitline = line.split()
                    if file == 'log196-2.txt': # change the subjectnr to 222 for the second participant we ran as 196 so that R knows they're different subjects
                        splitline[0] = 222
                    for ta in range(nrl):
                        minilist.append(splitline[ta])
                    alllogs.append(minilist)
                counter += 1
            g.close()
        # output to file
        outcsv = open(combfile, 'w')
        writer = csv.writer(outcsv, delimiter = ',', quotechar = '|', quoting = csv.QUOTE_MINIMAL, lineterminator = '\n')
        writer.writerow(headr)
        for it in alllogs:
            writer.writerow(it)
        outcsv.close()
if __name__ == '__main__':
  main()