function OCECgo_Tab_License(h)
% This function fills the "License" tab. MIT license text is inserted along
% with EERL/FlareNet images and the copyright text.

% Get parent
pnt1 = findobj(h, 'tag', 'Tab_Lic');

% Credit text
cred = {'\itOCECgo\rm is described in an article submitted to the \bfJournal of'; ...
    'Visualized Experiments\rm and is being shared free of charge as detailed'; ...
    'below. When using the software for analysis of data in published work,'; ...
    'it is requested that users cite/acknowledge the following:'; ...
    ' '; ...
    '    Conrad, B.M., Johnson, M.R., Calibration Protocol and Software for Split Point'; ...
    '    Analysis and Uncertainty Quantification of Thermal-Optical Organic / Elemental'; ...
    '    Carbon Measurements, \bfJ. Vis. Exp.\rm (2019), \itsubmitted\rm.'; ...
    ' '; ...
    'Copyright \copyright 2019 Bradley Conrad'; ...
    ' '; ...
    'Permission is hereby granted, free of charge, to any person obtaining a'; ...
    'copy of this software and associated documentation files (the "Software"),'; ...
    'to deal in the Software without restriction, including without limitation'; ...
    'the rights to use, copy, modify, merge, publish, distribute, sublicense,'; ...
    'and/or sell copies of the Software, and to permit persons to whom the'; ...
    'Software is furnished to do so, subject to the following conditions:'; ...
    ' '; ...
    'The above copyright notice and this permission notice shall be included'; ...
    'in all copies or substantial portions of the Software.'; ...
    ' '; ...
    'THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF'; ...
    'ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED'; ...
    'TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A'; ...
    'PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT'; ...
    'SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR'; ...
    'ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN'; ...
    'ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,'; ...
    'OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE'; ...
    'OR OTHER DEALINGS IN THE SOFTWARE.'};

% Add license text
axes(pnt1, 'Units', 'pixels', 'Position', [0 0 1260 675], 'visible', 'off')
text(gca, 0.1, 0.92, cred, 'FontSize', 11, 'HorizontalAlignment', 'left', 'verticalalignment', 'top')
set(gca, 'xlim', [0 1], 'ylim', [0 1])

% Add version details
vers = {'This is \itOCECgo\rm \bfversion 0.9\rm'; ...
    '\it\color{red}(working version for JoVE Review)\rm'; ...
    '\color{black}'; ...
    'Check for updates:'};
text(gca, 0.7, 0.75, vers, 'FontSize', 12, 'HorizontalAlignment', 'left', 'verticalalignment', 'top')

% Add update button
go_arrow = imread([h.UserData.folder_base, filesep, 'support\OCECgo_Images_GoArrow.png']);
uicontrol(pnt1, 'Style', 'pushbutton', 'Position', [1025 419 130 28], 'cdata', go_arrow, 'tag', 'temp', 'BackgroundColor', 'w', 'Callback', @Callback_UpdateCheck);

% Add copyright
OCECgo_TabSupport_Copyright(pnt1)
end

function Callback_UpdateCheck(~, ~)
% This callback takes the user to the OCECgo github page, where the user
% can download the latest release of the software

msg = {'Upon acceptance of the JoVE article, this button will redirect'; ...
    'the user to a public repository with the latest release of the \itOCECgo\rm software.'};
CreateStruct.Interpreter = 'tex';
CreateStruct.WindowStyle = 'modal';
uiwait(msgbox(msg, 'Info', 'help', CreateStruct))

end