close all
clear all
home

% MATLAB code to retrieve the amplitude and phase from interferograms I1,I2,I3 and I4

% load the interferograms files I1,I2,I3 and I4 with .png extension (it can be other format)
I1 = double(imread('I1.png')); 
I2 = double(imread('I2.png')); 
I3 = double(imread('I3.png'));
I4 = double(imread('I4.png')); 

% calculus of amplitude and phase from Eqs 6 and 7, respectively
retrieved_amplitude = sqrt((I3-I1).^2+(I4-I2).^2);
retrieved_amplitude =retrieved_amplitude-min(retrieved_amplitude(:));   % amplitude normalization
retrieved_amplitude =retrieved_amplitude/max(retrieved_amplitude(:));

retrieved_phase = atan2((I4-I2),(I3-I1));
retrieved_phase = retrieved_phase/2;                                    % phase setting between -pi/2 to pi/2

% to see the retreived amplitude and phase patterns
figure(1);subplot(1,2,1);imagesc(retrieved_amplitude);title('retrieved amplitude');colorbar;
pbaspect([1 1 1])
axis off
figure(1);subplot(1,2,2);imagesc(retrieved_phase);title('retrieved phase');colorbar;
pbaspect([1 1 1]) 
axis off
set(gcf, 'pos',[50 50 1200 600]);