function frame = javatest(m1, device_number)
% This function creates a "figure" with these features:
% - full window 
% - no borders
% - located at the selected screen

% if your SLM is not the 1st or 2nd screen, set manually the proper position
if device_number ~= 2
    main_device = 1;
else
    main_device = 2;
end

% get the position and size of the SLM screen
ge = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment();
gds = ge.getScreenDevices();
height = gds(device_number).getDisplayMode().getHeight();
width = gds(device_number).getDisplayMode().getWidth();
width_desp = gds(main_device).getDisplayMode().getWidth();

% check some parameters of the mask
image = uint8(m1);
if ~isa(image,'uint8')
    error('Image matrix must be of UINT8 type');
elseif ~isequal(size(image,3),3)
    error('Image must be NxMx3 RGB');
elseif ~isequal(size(image,1),height)
    error(['Image must have verticle resolution of ' num2str(height)]);
elseif ~isequal(size(image,2),width)
    error(['Image must have horizontal resolution of ' num2str(width)]);
end

% create the java frame object and insert the image into
jimg = im2java(m1);
frame = javax.swing.JFrame;
frame.setUndecorated(true);
icon = javax.swing.ImageIcon(jimg);
label = javax.swing.JLabel(icon);
frame.getContentPane.add(label);
frame.pack;
screenSize = get(0,'ScreenSize');  %#ok<NASGU> %# Get the screen size from the root object

% set size and position of the image
frame.setSize(width,height);
frame.setLocation(width_desp,0);
% show image
frame.show;

% If you want close the frame, you must write the code "frame.dispose();"