% MATLAB code to to send a phase pattern to the SLM, and 
% previously pass from radians to gray leves values


% Example of parameters (depends on calibration!) used in the bellow polynomial to convert radians into gray level values
g1=-0.136379447757097;
g2=2.163445652734163;
g3=-8.147651709725977;
g4=25.582763892492611;
g5=1.849302205167792;

% Polynomial 
mask=round(g1.*alpha.^4+g2.*alpha.^3+g3.*alpha.^2+g4.*alpha+g5);
% alpha holds for the phase element given by Eq. 5 in radians
% mask is the phase pattern in gray level values to be sent to the SLM

% general checks
mask=uint8(mask);           % image must be uint8
s = size(mask);
B=uint8(zeros(s(1),s(2),3));
B(:,:,2)=mask;              % B is a RGB image with the phase pattern "mask" put at the green channel
                            % Caution: The assigned channel can vary depending on the SLM

% The following code is employed to send the RGB image to the SLM by using the "javatest" function 

% javatest has 2 arguments (B: RGB image to be sent to the SLM, and n: the screen number assigned to the SLM in the computer).

frame = javatest(B,2); % send the RGB image with the javatest function
        
% stop the program until measurement is performed
pause()

% close the sent RGB image
frame.dispose();