#!/bin/bash
#PREPARE FILES FOR BCFTOOLS USING BGZIP AND TABIX
bgzip parental1.1.raw.vcf && tabix parental1.1.raw.vcf.gz
bgzip parental1.2.raw.vcf && tabix parental1.2.raw.vcf.gz
bgzip parental1.3.raw.vcf && tabix parental1.3.raw.vcf.gz
bgzip mutant1.1.raw.vcf && tabix mutant1.1.raw.vcf.gz
bgzip mutant1.2.raw.vcf && tabix mutant1.2.raw.vcf.gz
bgzip mutant1.3.raw.vcf && tabix mutant1.3.raw.vcf.gz
bgzip parental2.1.raw.vcf && tabix parental2.1.raw.vcf.gz
bgzip parental2.2.raw.vcf && tabix parental2.2.raw.vcf.gz
bgzip parental2.3.raw.vcf && tabix parental2.3.raw.vcf.gz
bgzip mutant2.1.raw.vcf && tabix mutant2.1.raw.vcf.gz
bgzip mutant2.2.raw.vcf && tabix mutant2.2.raw.vcf.gz
bgzip mutant2.3.raw.vcf && tabix mutant2.3.raw.vcf.gz
bgzip parental3.1.raw.vcf && tabix parental3.1.raw.vcf.gz
bgzip parental3.2.raw.vcf && tabix parental3.2.raw.vcf.gz
bgzip parental3.3.raw.vcf && tabix parental3.3.raw.vcf.gz
bgzip mutant3.1.raw.vcf && tabix mutant3.1.raw.vcf.gz
bgzip mutant3.2.raw.vcf && tabix mutant3.2.raw.vcf.gz
bgzip mutant3.3.raw.vcf && tabix mutant3.3.raw.vcf.gz
#BCFTOOLS INTERSECTION TOOL FOR COMMON VARIANTS
bcftools isec -n+1 parental1.1.raw.vcf.gz parental1.2.raw.vcf.gz parental1.3.raw.vcf.gz mutant1.1.raw.vcf.gz mutant1.2.raw.vcf.gz mutant1.3.raw.vcf.gz > PARENTAL1.1_2_3.v.MUTANT1.1_2_3.list
bcftools isec -n+1 parental2.1.raw.vcf.gz parental2.2.raw.vcf.gz parental2.3.raw.vcf.gz mutant2.1.raw.vcf.gz mutant2.2.raw.vcf.gz mutant2.3.raw.vcf.gz > PARENTAL2.1_2_3.v.MUTANT2.1_2_3.list
bcftools isec -n+1 parental3.1.raw.vcf.gz parental3.2.raw.vcf.gz parental3.3.raw.vcf.gz mutant3.1.raw.vcf.gz mutant3.2.raw.vcf.gz mutant3.3.raw.vcf.gz > PARENTAL3.1_2_3.v.MUTANT3.1_2_3.list
#CONCATENATES ALL FILES WITH 'FILENAME:' APPENDED TO START OF LINE
grep -H "." PARENTAL*.list > all.list
# PYTHON SCRIPT TO COLLATE AND ANNOTATE VARIANTS USING A GENOME FILE AND GFF FILE
# PATTERNS ARE THE BINARY PATTERNS OF PRESENCE/ABSENCE FROM THE BCFTOOLS INTERSECTION FILES (ORDER OF FILES TRANSLATES INTO BINARY STRING WHERE 0 = FILE DOES NOT HAVE VARIANT, 1 = FILE HAS VARIANT)
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000001 --out all.list.filter.000001
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000010 --out all.list.filter.000010
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000100 --out all.list.filter.000100
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000011 --out all.list.filter.000011
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000101 --out all.list.filter.000101
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000110 --out all.list.filter.000110
python3 variant_characterize.py --list all.list --gff schizosaccharomyces_pombe.chr.gff3 --fasta Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa --pattern 000111 --out all.list.filter.000111
