#!/bin/bash
##INPUT PARAMETERS
FASTQ1=[FASTQ1 FILE NAME PREFIX]
FASTQ2=[FASTQ2 FILE NAME PREFIX]
INPUTSAM=[INSERT FILE NAME].sam
BARCODE=[INSERT BARCODE HERE]
SAMPLENUMBER=[INSERT SAMPLE NUMBER HERE]
GENOME=Schizosaccharomyces_pombe.ASM294v2.30.dna.genome.fa
VCFOUTPUT=$FILENAME.raw.vcf
##COMMANDS TO BE RUN FOR EACH SAMPLE'S PAIRED FASTQ FILES
python3 shear.py --fq1 $FASTQ1.fastq --fq2 $FASTQ2.fastq --out1 $FASTQ2.shear.fastq --out2 $FASTQ2.shear.fastq --barcodes1 $BARCODE --platform TruSeq --trimqual 20:20 --trimpolyat 0 --trimambig --filterlength 50 --filterunpaired 
bwa mem -t 8 $GENOME $FASTQ1.shear.fastq $FASTQ2.shear.fastq > $INPUTSAM
java -Xmx30g -jar picard.jar AddOrReplaceReadGroups INPUT=$INPUTSAM OUTPUT=$FILENAME.bam.mark RGID=1 RGLB=lib01 RGPL=illumina RGPU=$BARCODE RGSM=$SAMPLENUMBER
samtools fixmate -O bam $FILENAME.bam.mark $FILENAME.bam.fix
samtools sort -O bam -o $FILENAME.bam.sort -T /home/peasejb/tmp $FILENAME.bam.fix
samtools index $FILENAME.bam.sort
java -Xmx30g -jar GenomeAnalysisTK.jar -T HaplotypeCaller -R $GENOME -I $FILENAME.bam.sort --genotyping_mode DISCOVERY -stand_emit_conf 10 -stand_call_conf 30 -o $VCFOUTPUT
