function fSeeRandomTraces(vesicles3D)
% V1. This function shows random 4x4 "fluorescence ratios vs. time" plots from
% given vesicles3D structure.

nTraces = 16;

% check if there are enough vesicles to show 16 plots
if size(vesicles3D, 1) < nTraces; nTraces = size(vesicles3D, 1); end

randIndex = randperm(size(vesicles3D, 1), nTraces);

for i = 1:length(randIndex)
    subplot(4,4,i)
    
    index = randIndex(i);
    % calculating the volumes of gaussian peaks
    volCh1 = 2 .* pi .* [vesicles3D(index, 1, :).a] .* [vesicles3D(index, 1, :).sx] .* [vesicles3D(index, 1, :).sy];
    volCh2 = 2 .* pi .* [vesicles3D(index, 2, :).a] .* [vesicles3D(index, 2, :).sx] .* [vesicles3D(index, 2, :).sy];
    time = [vesicles3D(index, 1, :).timestamp];
    plot(time, volCh1 ./ volCh2);
    axis('tight');
    ylim([0.1, 1.2]);
    title(strcat('ID=', string(vesicles3D(index).id),...
        ' (',string(vesicles3D(index).m),...
        ',', string(vesicles3D(index).n), ')'));
end