function fSaveTraces(traces)
% V1. This function saves the ratio and pH traces for each
% vesicle in 'ratio.vttratio' and 'pH.vttph' files

global PARAM;
filenameRatio = char(strcat(PARAM.folder, '\ratio.vttratio'));
filenamepH = char(strcat(PARAM.folder, '\pH.vttph'));

% creating empty matrix to populate with data
dataRatio = zeros(length(traces(1).time), size(traces, 1)+1);
% writing timestamps in the first column
dataRatio(:,1) = [traces(1).time]';
datapH = dataRatio;

% unfolding the necessary parameters in the 'Vesicles x Time' arrays for 2
% channels
ratio = reshape([traces(:).ratio]', length(traces(1).time), length(traces));
pH = reshape([traces(:).pH]', length(traces(1).time), length(traces));


% writing data matrix with intensity ratio 'Time x Vesicles' array
dataRatio(:,2:end) = ratio;
datapH(:,2:end) = pH;

% preparing the header with vesicles ids and combining with data
ids = [NaN, traces(:).id];
dataToWriteRatio = [ids; dataRatio];
dataToWritepH = [ids; datapH];

% writing the file using TAB as delimeter
dlmwrite(filenameRatio,dataToWriteRatio, '\t')
dlmwrite(filenamepH,dataToWritepH, '\t')


