function z = fGauss2D(params, xyData)
% returns 2D gaussian with given parameters

x0=params(:,1);   % the centre's x coordinate
y0=params(:,2);   % the centre's y coordinate
sX=params(:,3);   % the x spread of the peak
sY=params(:,4);   % the y spread of the peak
a=params(:,5);    % the amplitude of the peak
b=params(:,6);    % the baseline of the peak
x=xyData(:,1);
y=xyData(:,2);

z=a.*exp(-((x-x0).^2./(2.*(sX.^2)))-((y-y0).^2./(2.*(sY.^2))))+b;
end