function newTraces = fFilterTraces(traces)
% V1. This function removes bad points from timetraces if they are:
% - out of calibration range
% - significant outliners
% It further verifies if resulting vesicles are complete enough to be used
% and put delFlag on incomplete ones

global PARAM;
lowerLimit = PARAM.pHCalib(2);
upperLimit = PARAM.pHCalib(3);

newTraces = traces;
[newTraces(:).smoothRatio] = deal([]);
[newTraces(:).delFlag] = deal(false);

for i=1:length(traces)
    xdata = traces(i).time;
    ydata = traces(i).ratio;
    
    % marking as NaNs all points out of calibration range
    outOfLimitsMask = (ydata > upperLimit) | (ydata < lowerLimit);
    ydata(outOfLimitsMask) = NaN;
    
    % detecting and marking as NaNs all ouliers
    outlierMask = isoutlier(ydata, 'movmedian', 15, 'ThresholdFactor', 3, 'SamplePoints', xdata); % these parameters can be varied 
    ydata(outlierMask) = NaN;
    
    % calculates smoothed traces for better vizualisation
    newTraces(i).smoothRatio = smoothdata(ydata, 'rlowess', 30, 'omitnan', 'SamplePoints', xdata);
    
    % detecting vesicles with gap larger than 5 consecutive points
    nonNanIdx = find(~isnan(ydata));
    maxGap = max(diff(nonNanIdx));
    if maxGap > 5
        newTraces(i).delFlag = true;
    end
    
    % detecting vesicles with more than 20% of lost points
    if length(ydata(~isnan(ydata))) < 0.8*length(ydata)
        newTraces(i).delFlag = true;
    end
    
    newTraces(i).time = xdata;
    newTraces(i).ratio = ydata;
end