function vesicles = fCreateVesicles(coorPeaks)
% V1. This function writes peak coordinates to vesicles structure and
% attaches date and experiment id.
global PARAM;

% retrieves experiment date and name from folder names
% expects files to be in \"date"\"name"\ location
date = char(regexp(PARAM.folder, '(?<=\\)[0-9\-^\\]+(?=\\.+)', 'match'));
experiment = char(regexp(PARAM.folder, '(?<=\\)[^\\]+$', 'match'));

% creating vesicles structure with date, experiment identifier and vesicles
% coordinates known
vesicles = struct('date', date,...
    'experiment', experiment,...
    'id', [],...
    'm', num2cell(coorPeaks(2:2:end)),...
    'n', num2cell(coorPeaks(1:2:end)));

% writing vesicles ids
temp = num2cell(1:length(vesicles));
[vesicles(:).id] = temp{:};
fprintf('%d initial maximums are found', length(vesicles));
