function newTraces = fCalculatepH(traces)
% V1. This function converts fluorescence ratio to pH using a calibration
% curve

% retrieving calibration parameters
global PARAM;
pKa = PARAM.pHCalib(1);
Ra = PARAM.pHCalib(2);
Rb = PARAM.pHCalib(3);
b = PARAM.pHCalib(4); % e(A-)/e(HA) at 405nm 

newTraces = traces;
[newTraces(:).pH] = newTraces.ratio;

for i=1:length(newTraces)
    R = newTraces(i).ratio;
    newTraces(i).pH = pKa + log10( (R-Ra)./(b*(Rb-R)) );
    
end

end