function threshold = fCalculateThreshold(meanImgCh2, ofset)
% V1. This function calculates approximative threshold for the initial
% peaks search based on the image histogram

%ofset : how higher above baseline the peaks should be (relative to baseline)
[counts, bins] = histcounts(meanImgCh2, 'BinMethod', 'integers');
bins = ceil(bins);
bins = bins(1:end-1);
[~, idx] = max(counts);
baseline = bins(idx);
threshold = (1 + ofset) * baseline;

