function fWriteGif(img4D, fittedImg4D, vesiclesFrames, ids)
% V1. This function combine real and fitted images of passed vesicles on
% both channels and all timeframes and writes them as animated gif into
% working folder with name 'idX.gif'.
global PARAM;

% iterating over all passed vesicles id
for id = 1:length(ids)
    %find index of vesicle with passed id
    index = find([vesiclesFrames(:,1,1).id] == ids(id));
    if index == 0
        continue;
    end
    vesicleCh1 = vesiclesFrames(index,1,:);
    vesicleCh2 = vesiclesFrames(index,2,:);
    
    gif = {};
    
    % creating the 1000x500 figure and finding minimal and maximal values
    % of intensity for both channels to be used as z-axis limits
    fig = figure;
    set(fig, 'Position', [0, 0, 1000, 500]);
    zMin = min([[vesicleCh1(:).b], [vesicleCh2(:).b]]) - 10;
    zMax = max([[vesicleCh1(:).b]+[vesicleCh1(:).a], [vesicleCh2(:).b]+[vesicleCh2(:).a]]);
    
    % iterating over each time frame and creating figure
    for time = 1:size(vesiclesFrames, 3)
        
        % 1st subplot for channel 1 (470 nm)
        subplot(1,2,1);
        img = img4D(:,:,1,time);
        fittedImg = fittedImg4D(:,:,1,time);
        %surface plot - real image, mesh plot - fitted image
        surf(img(vesicleCh1(:,:,time).m-PARAM.fitM:vesicleCh1(:,:,time).m+PARAM.fitM, vesicleCh1(:,:,time).n-PARAM.fitN:vesicleCh1(:,:,time).n+PARAM.fitN),'LineStyle', 'none');
        hold on;
        mesh(fittedImg(vesicleCh1(:,:,time).m-PARAM.fitM:vesicleCh1(:,:,time).m+PARAM.fitM, vesicleCh1(:,:,time).n-PARAM.fitN:vesicleCh1(:,:,time).n+PARAM.fitN),...
            'FaceAlpha', 0, 'LineWidth', 1, 'EdgeColor', [0 0 0]);
        % adjasting figure axis and creating subplot title
        axis tight;
        zlim([zMin, zMax]);
        subTitle = sprintf('HPTS 470nm, %03d s', round(vesicleCh1(:,:,time).timestamp));
        title(subTitle);
        hold off;
        
        % 2nd subplot for channel 2 (410 nm)
        subplot(1,2,2);
        img = img4D(:,:,2,time);
        fittedImg = fittedImg4D(:,:,2,time);
        %surface plot - real image, mesh plot - fitted image
        surf(img(vesicleCh2(:,:,time).m-PARAM.fitM:vesicleCh2(:,:,time).m+PARAM.fitM, vesicleCh2(:,:,time).n-PARAM.fitN:vesicleCh2(:,:,time).n+PARAM.fitN),'LineStyle', 'none');
        hold on;
        mesh(fittedImg(vesicleCh2(:,:,time).m-PARAM.fitM:vesicleCh2(:,:,time).m+PARAM.fitM, vesicleCh2(:,:,time).n-PARAM.fitN:vesicleCh2(:,:,time).n+PARAM.fitN),...
            'FaceAlpha', 0, 'LineWidth', 1, 'EdgeColor', [0 0 0]);
        % adjasting figure axis and creating subplot title
        axis tight;
        zlim([zMin, zMax]);
        subTitle = sprintf('HPTS 410nm, %03d s', round(vesicleCh2(:,:,time).timestamp));
        title(subTitle);
        hold off;
        
        % creating plot supertitle with vesicle id and coordinates
        supTitle = sprintf('ID = %d, (%dx%d)', ids(id), vesicleCh1(:,:,time).m, vesicleCh1(:,:,time).n);
        suptitle(supTitle);
        
        % updating figure and appending it as frame to gif variable
        drawnow;
        frame = getframe(fig);
        gif{time} = frame2im(frame);
        
    end
    close(fig);
    
    filename = char(strcat(PARAM.folder, '\id', string(ids(id)), '.gif'));
    % iterating over saved frames and writing them as gifs
    for nFrame = 1:length(gif)
        % you have to convert rgb to indexed colors and retrieve colormap
        [gifFrame,map] = rgb2ind(gif{nFrame},256);
        if nFrame == 1
            % if 1st frame, creating and parametrizing gif file
            imwrite(gifFrame,map,filename,'gif','LoopCount',Inf,'DelayTime',0.1);
        else
            % if not 1st frame, appending frame to the gif
            imwrite(gifFrame,map,filename,'gif','WriteMode','append','DelayTime',0.1);
        end
    end
    
end