function [frames, meanImgCh1, meanImgCh2]=fTifLoad(folder)
% V2. This function takes a string with whole path to the folder and proceeds
% all images in this folder taking into account that they belongs to a
% single timetrace experiment. It uses a specific filename mask to proceed
% the images. It returns a 4D-matrix (M-N-C-T) with cropped timefrimes
% and two averaged images on two channels.

files = dir(folder);

% assuming that filenames and on ..._c1_tXXX.tif  or ..._c0_tXXX.tif
fileRegExpCh1 = '.+_c1_t[0-9]+\.tif';   %HPTS_H or 470 nm
fileRegExpCh2 = '.+_c0_t[0-9]+\.tif';   %HPTS_L or 410 nm

%cropping size
MCrop=10;
NCrop=10;

chanel1 = {};
chanel2 = {};

for iFile = 1:size(files, 1)
    if string(regexp(files(iFile).name, fileRegExpCh1, 'match')) == files(iFile).name
        chanel1{end+1} = strcat(files(iFile).folder, '\', files(iFile).name);
    elseif string(regexp(files(iFile).name, fileRegExpCh2, 'match')) == files(iFile).name
        chanel2{end+1} = strcat(files(iFile).folder, '\', files(iFile).name);
    end        
end

% loads images into two datastores (for each channel)
imgDataStoreCh1 = imageDatastore(chanel1);
imgDataStoreCh2 = imageDatastore(chanel2);


% reads first image as a witness
firstImgCh1 = readimage(imgDataStoreCh1, 1);
M = size(firstImgCh1, 1);
N = size(firstImgCh1, 2);

% prepares an empty 4D-matrix (M-N-C-T) to store timeframes and images for averaging
frames = zeros(M, N, 2, max(length(imgDataStoreCh1.Files), length(imgDataStoreCh2.Files)), 'uint16');
meanImgCh1 = zeros(size(firstImgCh1), 'uint32');
meanImgCh2 = meanImgCh1;

% goes through images and sums them up
while hasdata(imgDataStoreCh1)
    [img, info] = read(imgDataStoreCh1);
    meanImgCh1 = meanImgCh1 + uint32(img);
    
    %retrieves timeframe No from filename, stores image in the frames
    timeIndex = str2double(regexp(info.Filename, '[0-9]+(?=\.tif)', 'match'))+1; %beacause filenames starts with 0-index
    frames(:,:,1,timeIndex) = img;
end

while hasdata(imgDataStoreCh2)
    [img, info] = read(imgDataStoreCh2);
    meanImgCh2 = meanImgCh2 + uint32(img);
    
    %retrieves timeframe No from filename, stores image in the frames
    timeIndex = str2double(regexp(info.Filename, '[0-9]+(?=\.tif)', 'match'))+1; %beacause filenames starts with 0-index
    frames(:,:,2,timeIndex) = img;
end

% crops and averages the channels, converts back to uint16
meanImgCh1 = meanImgCh1((MCrop+1):(M-MCrop),(NCrop+1):(N-NCrop))/ length(imgDataStoreCh1.Files);
meanImgCh2 = meanImgCh2((MCrop+1):(M-MCrop),(NCrop+1):(N-NCrop))/ length(imgDataStoreCh2.Files);
meanImgCh1 = uint16(meanImgCh1);
meanImgCh2 = uint16(meanImgCh2);

%crops timeframes
frames = frames((MCrop+1):(M-MCrop),(NCrop+1):(N-NCrop),:,:);

% saves mean images in the same folder
fileToSaveCh1 = string(regexp(chanel1(1), '(?<=\\)[^\\]+(?=_t[0-9]+\.tif)', 'match'));
fileToSaveCh2 = string(regexp(chanel2(1), '(?<=\\)[^\\]+(?=_t[0-9]+\.tif)', 'match'));

save(strcat(folder, '\', fileToSaveCh1, '_', 'meanImgCh1'), 'meanImgCh1');
save(strcat(folder, '\', fileToSaveCh2, '_', 'meanImgCh2'), 'meanImgCh2');

end