function fSaveVesicles(vesicles3D)
% V1. This function calculates the ratio and saves the time traces for each
% vesicles in 'vesiclesTraces.vtt' file

global PARAM;
filename = char(strcat(PARAM.folder, '\vesiclesTraces.vtt'));

% creating empty matrix to populate with data
data = zeros(size(vesicles3D, 3), size(vesicles3D, 1)+1);
% writing timestamps in the first column
data(:,1) = [vesicles3D(1,1,:).timestamp]';

% unfolding the necessary parameters in the 'Vesicles x Time' arrays for 2
% channels
ampl1 = reshape([vesicles3D(:,1,:).a], size(vesicles3D, 1), size(vesicles3D, 3));
sx1 = reshape([vesicles3D(:,1,:).sx], size(vesicles3D, 1), size(vesicles3D, 3));
sy1 = reshape([vesicles3D(:,1,:).sy], size(vesicles3D, 1), size(vesicles3D, 3));
ampl2 = reshape([vesicles3D(:,2,:).a], size(vesicles3D, 1), size(vesicles3D, 3));
sx2 = reshape([vesicles3D(:,2,:).sx], size(vesicles3D, 1), size(vesicles3D, 3));
sy2 = reshape([vesicles3D(:,2,:).sy], size(vesicles3D, 1), size(vesicles3D, 3));

% calculating the volumes of peaks in the 'Time x Vesicles' arrays for 2
% channels
vol1 = 2 .* pi .* ampl1' .* sx1' .* sy1';
vol2 = 2 .* pi .* ampl2' .* sx2' .* sy2';

% writing data matrix with intensity ratio 'Time x Vesicles' array
data(:,2:end) = vol1./vol2;

% preparing the header with vesicles ids and combining with data
ids = [NaN, vesicles3D(:,1,1).id];
dataToWrite = [ids; data];

% writing the file using TAB as delimeter
dlmwrite(filename,dataToWrite, '\t')


