function medianTrace = fGetMedian(filteredVesicles3D)
% V2. This function gets filtered timetraces and averages (actually takes
% MEDIAN) all of them to check traces tendencies. It also saves median
% trace to a file
global PARAM;
timestamps = [filteredVesicles3D(1,1,:).timestamp];
ratios = [filteredVesicles3D(:,1,:).ratio];
ratios = reshape(ratios, [size(filteredVesicles3D, 1), size(filteredVesicles3D, 3)]);
medianRatios = median(ratios);
medianTrace(1,:) = timestamps;
medianTrace(2,:) = medianRatios;
medianTrace = [NaN, medianTrace(1,:); NaN, medianTrace(2,:)];
dlmwrite(char(strcat(PARAM.folder, '\median_traces.vtt')), medianTrace.', '\t');