function traces = fConvertVesicles(filteredVesicles3D)
%V1. This function converts vesicles3D structure to a simplified 1D
%structure used hereafter to work with pH traces of vesicles only.

% First vesicle at first timestep and first channel is taken as a base
traces = filteredVesicles3D(1:end,1,1);
fields = fieldnames(traces);

% removing all the fields except the core ones
fieldsToDelete = fields(~ismember(fields, {'date','experiment', 'id', 'm', 'n', 'diameter'}));
traces = rmfield(traces, fieldsToDelete);

% populates "time" columns
[traces(:).time] = deal([filteredVesicles3D(1,1,1:end).timestamp]);

% transfers "ratio" column for all vesicles
for i=1:length(traces)
    traces(i).ratio = [filteredVesicles3D(i,1,1:end).ratio];
end

