function [Objects,ThrImg] = segment_fromImage(img, par)

%Segmentation of cells from the image. 

sigma = par(1);    %sigma of the gaussian blurring of the image
minSize = par(2);  %minimum size of the objects for the BLUE image
factor = par(3);   %for the first thresholding.
maxSize=par(4);    %maximum size of the objects for the BLUE image

% Blur the  image

if sigma>0
    FilterImg = imfilter(img,fspecial('gaussian', 20,  sigma),'same');
else
    FilterImg = img;
end;
% Threshold the  image
    levelTr = factor*graythresh(FilterImg);
     ThrImg = im2bw (FilterImg, levelTr);
  
% Exclude the small objects in the  thresholded image
    ThrImg = imfill(ThrImg,'holes'); % fill holes
    ThrImg = bwareaopen(ThrImg,minSize);
     
    Objects=segment_fromMask(ThrImg, [minSize,maxSize]);
    

end

