function plot_trajs_singlecells(Stack,namefiletracks,filetrackfolder)

workingdir=pwd;



figure(1)

cd(filetrackfolder)
load(namefiletracks);
cd(workingdir)
n_tracks = numel(tracks);
colors = hsv(n_tracks);
colors=colors(randperm(length(colors)),:);

all_points = vertcat(points{:});

 frames_points=[]; 
 for n=1:length(points)
 frames_points=[frames_points;n*ones(length(points{n}),1)];
 end; 



 

[nFrames,nCells]=size(matricesofX);




hStack = axes('Position', [.05, .3, .45, .6]);

A=double(Stack(1).data);

minimum=mean(A(:))-std(A(:));

maximum=mean(A(:))+3*std(A(:)); 

limitstouse=[minimum, maximum]; 

imagesc(Stack(1).data,limitstouse);
title(num2str(1))
colormap('gray')
%colormap('jet')
hold(hStack, 'on');
pointsframe=points{1};
plot(pointsframe(:,1), pointsframe(:,2),'g+');

hPlot = axes('Position', [.55, .3, .40, .6]);

X=matricesofX(:,1);
Y=matricesofY(:,1);

rightframes=find(~isnan(X));
plot(hPlot,X,Y,'g',matricesofX(1,1),matricesofY(1,1),'ko');
axis([1 1024 1 1024])
set(hPlot,'Ydir','reverse')

%axis([1 1024 1 1024]);
%axis([matricesofX(1,1)-200, matricesofX(1,1)+200, matricesofY(1,1)-200,matricesofY(1,1)+200]);

setappdata(hStack, 'iFrame', 1);
setappdata(hStack, 'iCell', 1);

[nFrames,nCells]=size(matricesofX)


hFrameSlider = uicontrol( ...
    'Style', 'slider', ...
    'Value', 1,...
    'Min', 1, 'Position',[30,64,500,23],...
    'Max',  nFrames, ...
    'SliderStep', [1/nFrames, 1/nFrames],...
    'Callback', @(src, evt) changeFrame(hStack, hPlot, get(src, 'Value'), ...
     Stack, nFrames,matricesofX,matricesofY,limitstouse,points));


hCellSlider = uicontrol( ...
    'Style', 'slider', ...
    'Value', 1,...
    'Min', 1,'Position',[30,24,500,23],...
    'Max',  nCells, ...
    'SliderStep', [1/nCells, 1/nCells],...
    'Callback', @(src, evt) changeCell(hStack, hPlot, get(src, 'Value'),...
     Stack, nFrames,matricesofX,matricesofY,limitstouse,points));









function changeFrame(hStack, hPlot, iFrame, ...
    Stack, nFrames,matricesofX,matricesofY,limitstouse,points)




iFrame = round(iFrame);
iCell = getappdata(hStack, 'iCell');

X=matricesofX(:,iCell);
Y=matricesofY(:,iCell);

imagetouse=Stack(iFrame).data;

imagesc(imagetouse, 'Parent', hStack,limitstouse);

rightframes=find(~isnan(X));

hold(hStack, 'on');
title(num2str(iFrame))
pointsframe=points{iFrame};
plot(hStack,pointsframe(:,1), pointsframe(:,2),'g+');

if (iFrame<=max(rightframes)) && (iFrame>=min(rightframes))

    
    
    
%axis(hStack, [max(X(iFrame)-200,1), min(X(iFrame)+200,1024), max(Y(iFrame)-200,1),min(Y(iFrame)+200,1024)]);


axis([1 1024 1 1024])
    
hold(hStack, 'on');
plot(hStack,X(iFrame), Y(iFrame),'or',...
    'MarkerSize', 9);
hold(hStack, 'off');


else
    
axis([1 1024 1 1024])

    set(hPlot,'Ydir','reverse')
    

end;





plot(hPlot, matricesofX(:,iCell),matricesofY(:,iCell),'g',matricesofX(iFrame,iCell),matricesofY(iFrame,iCell),'ko')

axis([1 1024 1 1024])
    set(hPlot,'Ydir','reverse')
    




title(num2str(iCell))
 title(hStack, num2str(iFrame))
setappdata(hStack, 'iFrame', iFrame);




function changeCell(hStack, hPlot,  iCell, ...
Stack, nFrames,matricesofX,matricesofY,limitstouse,points)


iFrame = getappdata(hStack, 'iFrame');
iCell = round(iCell);


X=matricesofX(:,iCell);
Y=matricesofY(:,iCell);

imagetouse=Stack(iFrame).data;

imagesc(imagetouse, 'Parent', hStack,limitstouse);
hold(hStack, 'on');

pointsframe=points{iFrame};
plot(hStack,pointsframe(:,1), pointsframe(:,2),'g+');
rightframes=find(~isnan(X));


if (iFrame<=max(rightframes)) && (iFrame>=min(rightframes))

%axis(hStack, [max(X(iFrame)-200,1), min(X(iFrame)+200,1024), max(Y(iFrame)-200,1),min(Y(iFrame)+200,1024)]);

axis([1 1024 1 1024])
    
hold(hStack, 'on');
plot(hStack,X(iFrame), Y(iFrame),'or',...
    'MarkerSize', 9);
hold(hStack, 'off');
axis([1 1024 1 1024])


else

 axis([1 1024 1 1024])
    set(hPlot,'Ydir','reverse')
    

   
    
end;


plot(hPlot, matricesofX(:,iCell),matricesofY(:,iCell),'g',matricesofX(iFrame,iCell),matricesofY(iFrame,iCell),'ko')

axis([1 1024 1 1024])

    set(hPlot,'Ydir','reverse')
    

title(num2str(iCell))


title(hStack, num2str(iFrame))
setappdata(hStack, 'iCell', iCell);




