clear

close all

hold off 


%FIRST IMPORTANT THING TO CHANGE: USE THE RIGHT PATH FOR THE TRACKING
%ROUTINES AND THE OUTPUT


path_routines_track='C:\Science\To Submit\Tracking Routines'; %Where your tracking routines routines are
pathoutput=pwd;

%SECOND IMPORTANT THING TO CHANGE: USE THE RIGHT NAME OF THE FILE OF THE
%SEGMENTATION RESULTS (WE ASSUME THAT THEY ARE IN THE CURRENT FOLDER)

filenamepoints=('SegmentExample.mat');

load(filenamepoints);

filenametracks=strrep(filenamepoints,'Segment', 'Tracked'); 


%Parameters to be used for the tracking

n_dim = 2;
n_frames= length(points);

max_linking_distance = 20; 
max_gap_closing = 5;
debug = true;


cd(path_routines_track)

[ tracks,adjacency_tracks ] = simpletracker(points,...
    'MaxLinkingDistance', max_linking_distance, ...
    'MaxGapClosing', max_gap_closing, ...
    'Debug', debug);
n_tracks = numel(tracks);
all_points = vertcat(points{:});





[matricesofX, matricesofY] = MatricesXandYInterpfromTracks('rawtracks.mat'); 
%This function uses the "tracks" file and create a matrix of the X and Y
%coordinates of the trajectories. Since the tracking algorithm allows jumps
%in the trajecories (missing objects) the gaps are filled by linear
%interpolation. 


cd(pathoutput);

save(filenametracks,'matricesofX', 'matricesofY','max_linking_distance', 'max_gap_closing', 'debug','n_tracks','tracks','adjacency_tracks','all_points','points'); %Other relevant data is saved for potential subsequent use.

plot(matricesofX,matricesofY)
xlabel('X');
ylabel('Y'); 
axis('tight')
