
clear

hold off

close all


%FIRST IMPORTANT THING TO CHANGE: USE THE RIGHT PATH FOR THE SEGMENTATION
%ROUTINES AND THE OUTPUT

path_routines='C:\Science\To Submit\Segmentation Routines'; %Where your quantification routines are
pathOutput=pwd;


%SECOND IMPORTANT THING TO CHANGE: USE THE RIGHT PATH FOR THE NAME OF THE
%.TIF FILE TO BE ANALYZED AND WHERE TO FIND IT.

fileNameTrack='Example.tif' %File of the experiment, and folder where to find it
pathInputTrack='C:\Science\To Submit\Example Segmentation Tracking\'

%THIRD IMPORTANT THING TO CHANGE: USE THE RIGHT NAME OF THE FILE OF THE
%SEGMENTATION

load SegmentExample.mat 

cd(path_routines);
[StackTrack, nFrames] = TIFread([pathInputTrack, fileNameTrack]);
cd(pathOutput);

hold off
for n=1:nFrames
    figure(1)
    imagesc(StackTrack(n).data,[1 70000])
    [B,L] = bwboundaries(labelmatrix(cellROIsdef(n))>0);
    
    
    hold on;
    colormap('hot')
     for k = 1:length(B)
            boundary = B{k};
            plot(boundary(:,2), boundary(:,1), 'w', 'LineWidth', 1);
     end
   
  

 pause(1)
    
    
end;



