#!/usr/bin/python
from Bio import SeqIO
import sys
from sys import argv                        
blast_handle=open("%s"%argv[2], "r")
fasta_handle=open("%s"%argv[1], "r")
out_handle=open("%s_non-matching_sequences_%s.fasta"%(argv[1],argv[2]), "w")
out_handle2=open("%s_matching_sequences_%s.fasta"%(argv[1],argv[2]), "w")
e=float(1e-4)
Dict={}
for line in blast_handle:
	ident=line.split()[1]
	evalue=float(line.split()[10])
	if evalue < e:
		Dict[ident]=1
include=0
exclude=0
x=0
for seq_record in SeqIO.parse(fasta_handle,"fasta"):
	x+=1
	ident = seq_record.id
	if Dict.has_key(ident):
		include+=1
		out_handle2.write(">%s\n%s\n"%(seq_record.id, seq_record.seq))
	else:
		exclude+=1
		out_handle.write(">%s\n%s\n"%(seq_record.id, seq_record.seq))
print "%s sequences matching and %s sequences nonmatching out of %s total."%(include,exclude,x)
blast_handle.close()
fasta_handle.close()
out_handle.close()
out_handle2.close()
