function [V_base] = select_traces(file_struct, f_sample)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function selects the traces of a set of preprocessed datasets. 
% f_sample [Hz] = sampling frequency of event timestamps
% file_struct = the file structure of preprocessed datasets: 
% file_struct(file_number, feature_number) = [session_number recording_number
% baseline/response control/target dpf errors]
% 
% Note that:
% session_number = number of the session - should be present in the
% folder name;
% recording_number = number of the recording - should be present in the
% last digits of the recording name;
% baseline/response = 0 if the trace is recorded only during spontaneous
% activity; 1 if trace contains response to PTZ 
% control/target = 0 if the trace is recorded from a Mismatch control fish;
% 1 if trace is recorded from a DEPDC5 animal
%
% file_struct(1,:) = [11 2 1 0 4 0];
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% find number of datasets
no_sets = size(file_struct, 1);

% iterate through datasets
for i_dataset = 1:no_sets;
    
    % find datasests in file structure
    session_no = file_struct(i_dataset,1);
    file =  file_struct(i_dataset,2);

    session = ['Session ' num2str(session_no)];

    list = dir(session);
    filename = list(3,1).name;
    if file<10
        filename = [filename(1:7) num2str(file)];
    else
        filename = [filename(1:6) num2str(file)];
    end
    
    % load preprocessed traces
    load([session '\' filename '_filt.mat' ]);
    
    % extract trace and construct timebase
    V_base(i_dataset).trace = V_filt_analyze;
    V_base(i_dataset).t_base = 0:1/f_sample:(length(V_base(i_dataset).trace)-1)/f_sample;   

    % filter raw trace above 0.01 Hz for cleaner display
    [b_hfp,a_hfp] = butter(1, 0.01*2/f_sample, 'high');
    V_base(i_dataset).trace = filtfilt(b_hfp, a_hfp, V_base(i_dataset).trace);
    
end
%--------------------------------------------------------------------------


