title = getTitle();

//Dialog creation
Dialog.create("Tell me about your image acquisition");
//Number of images = planes x timepoints
Dialog.addNumber("Number of planes per timepoint: ", 5);
Dialog.addMessage("(Enter '1' for single plane)");
Dialog.addMessage("");
Dialog.addMessage("Timepoints:");
Dialog.addString("Define the range to analyze :", "11-80");
Dialog.addNumber("Define timepoints in baseline: ", 20);
Dialog.addNumber("Timepoints per temporal bin: ", 5);
Dialog.addNumber("Min Intensity: ", 200);
Dialog.addNumber("Max Intensity: ", 1600);
//get LUT directory
lutdir = getDirectory("luts");
err = "No LUTs in the '/ImageJ/luts' folder";
if (!File.exists(lutdir)) exit(err);
rawlist = getFileList(lutdir);
Dialog.addChoice("Choose a lookup table:", rawlist); //Prompt user for LUT
//Dialog.setInsets(0, 0, 0);
Dialog.addMessage("Lukasz et al, JoVE 2018");
Dialog.show();

spatial_bin = Dialog.getNumber();
range = Dialog.getString();
baseline = Dialog.getNumber();
temporal_bin = Dialog.getNumber();
min = Dialog.getNumber();
max = Dialog.getNumber();
type = Dialog.getChoice(); //type stores the LUT choice as a string (e.g. “Cyan Hot.lut”)
//12.

if (spatial_bin < 1) exit("Invalid number of planes");
if (spatial_bin > 1) {
	run("Grouped Z Project...", "projection=[Average Intensity] group=&spatial_bin");
}
//Remove first images from acquisition
run("Make Substack...", "  slices=&range");
rename("stk1");
//registration
run("StackReg ", "transformation=Translation");
rename("stk2");
//13.
//create a baseline image from stk2
run("Z Project...", "stop=&baseline projection=[Average Intensity]");
rename("baselineIMG");
//temporal binning
selectWindow("stk2");
run("Grouped Z Project...", "projection=[Average Intensity] group=&temporal_bin");
rename("stk2bin");
//baseline subtraction
imageCalculator("Subtract create stack", "stk2bin","baselineIMG");
//Set min/max and apply lookup table
rename("stk2binBL-LUT");
setMinAndMax(min, max);


run(substring(type,0,lengthOf(type)-4));
run("Apply LUT", "stack");
//Make RGB
run("RGB Color");
rename("stk2binBL-LUT-RGB");
selectWindow("stk2bin");
run("RGB Color");
rename("stk2bin-RGB");
//Superimpose heatmap onto grayscale original
imageCalculator("Transparent-zero create stack", "stk2bin-RGB","stk2binBL-LUT-RGB");
rename("stk2binBL-LUT-RGB-overlay");
//selectWindow("stk2binBL-LUT-RGB-overlay");
doCommand("Start Animation [\\]");