function [time_wave,resp_wave,L] = SPPplus_read_v1(filename,run_conv)
% This function reads data from the selected file, and performs any
% necessary unit conversions.
    %Inputs: filename = name of file to read (as a string)
            %run_conv = vector of unit conversion factors
    %Outputs: time_wave = Lx1 vector of time at each measurement point
            %resp_wave = Lx3 matrix of the strain, rate and stress data,
                %with each row representing a measuring point
            %L = number of measurement points in the extracted data

%Extract data from file
FID = fopen(filename,'rt');
datacell = textscan(FID, '%f %f %f %f','HeaderLines', 0,'CollectOutput',1);
fclose(FID);
A=datacell{1};

%Sort the extracted data into transient trajectories
time_wave=run_conv(1)*(A(:,1)-A(1,1));
resp_wave=[run_conv(2)*A(:,2),run_conv(3)*A(:,3),run_conv(4)*A(:,4)];
L=length(time_wave);

end

