function [] = SPPplus_print_v1(filename,Z,omega,Recon_Wave,Gp_t,Gpp_t,...
    G_speed,Gp_t_dot,Gpp_t_dot,ext_dat,Rec_Tvect,Rec_Nvect,Rec_Bvect,...
    analtype,notetypeA,notetypeZ)
% This function prints data from the SPP analysis to one or more text files,
% as specified by the user
    %Inputs: filename = name of file from which the data originated
            %Z = printable variable which depends on the technique used
                %(number of  harmonics used for fourier transform, step
                %size for numerical differentiation)
            %Recon_Wave = Lx3 matrix of the strain, rate and stress data
                %output by the analysis, with each row representing a
                %measuring point
            %Gp_t = Lx1 vector contaning G'_t values output by the analysis
            %Gpp_t = Lx1 vector contaning G''_t values output by the analysis
            %G_speed = Lx1 vector contaning modulus speeds output by the analysis
            %Gp_t_dot = Lx1 vector contaning dG'_t/dt values output by the analysis
            %Gpp_t_dot = Lx1 vector contaning dG''_t/dt values output by the analysis
            %ext_dat = binary value determining whether to produce the
                %extedned data file(s)
            %Rec_Tvect = Lx3 matrix of the tangent vector, with each row
                %representing a measuring point
            %Rec_Nvect = Lx3 matrix of the normal vector, with each row
                %representing a measuring point
            %Rec_Bvect = Lx3 matrix of the binormal vector, with each row
                %representing a measuring point
            %analtype = analysis method used (as a string)
            %notetypeA = text that varies based on method used (as a string)
            %notetypeZ = text that varies based on type of Z used (as a string)

%Standard SPP data file
%Output file name
fname=sprintf('%s_SPP_LAOS_%s.txt',filename,analtype);
%Set up title rows
hdr0={'SPP-LAOS v1.00','Source file: '};
hdr01={notetypeA,notetypeZ};
hdr00={'Frequency calculated = '};
hdr1={'Strain','Rate','Recon_Stress','G''_{t}','G"_{t}','Speed',...
    'dG''_{t}/dt','dG"_{t}/dt'}; % First Header
hdr2={'[-]','[1/s]','[Pa]','[Pa]','[Pa]','[Pa/s]','[Pa/s]','[Pa/s]'}; % Second header
%Print title rows
txt=sprintf('%s\t%s\t%s\t%s\t%s\t%i\t%s\t%f\r\n%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\r\n%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t\r\n',...
    hdr0{:},filename,hdr01{:},Z,hdr00{:},omega,hdr1{:},hdr2{:});
dlmwrite(fname,txt,'');
%Print SPP data
dlmwrite(fname,[Recon_Wave(:,1),Recon_Wave(:,2),Recon_Wave(:,3),Gp_t,Gpp_t,...
    G_speed,Gp_t_dot,Gpp_t_dot],'-append','delimiter', '\t','precision','%.7f','newline','pc');

%Extended SPP data file(s)
if ext_dat == 1
    %Output file name
    fname=sprintf('%s_SPP_LAOS_%s_TNBFRAME.txt',filename,analtype);
    %Set up title rows
    hdr0={'SPP-LAOS v1.00','Source file: '};
    hdr01={notetypeA,notetypeZ};
    hdr00={'Frequency calculated = '};
    hdr1={'Tangent(x)','Tangent(y)','Tangent(z)','Normal(x)','Normal(y)',...\
        'Normal(z)','Binormal(x)','Binormal(y)','Binormal(z)'}; % First Header
    hdr2={'[-]','[1/s]','[Pa]','[-]','[1/s]','[Pa]','[-]','[1/s]','[Pa]'}; % Second header
    %Print title rows
    txt=sprintf('%s\t%s\t%s\t%s\t%s\t%i\t%s\t%f\r\n%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\r\n%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t\r\n',...
        hdr0{:},filename,hdr01{:},Z,hdr00{:},omega,hdr1{:},hdr2{:});
    dlmwrite(fname,txt,'');
    %Print SPP data
    dlmwrite(fname,[Rec_Tvect(:,1),Rec_Tvect(:,2),Rec_Tvect(:,3),...
        Rec_Nvect(:,1),Rec_Nvect(:,2),Rec_Nvect(:,3),Rec_Bvect(:,1),...
        Rec_Bvect(:,2),Rec_Bvect(:,3)],'-append','delimiter', '\t','precision','%.7f','newline','pc');
end

end

