#include <Wire.h>
#include <Chronodot.h>             // include the library Chronodot
#include <Time.h>                  // include the library Time
#include <TimeAlarms.h>            // include the library TimeAlarms

Chronodot RTC;

time_t syncProvider()     //this does the same thing as RTC_DS1307::get()
{
  return RTC.now().unixtime();
}

void setup()
{
  Serial.begin(9600);     // initialize the serial port 
  Serial.println("Initializing Chronodot.");
  Wire.begin();
  RTC.begin();
  setSyncProvider(syncProvider);     //reference our syncProvider function instead of RTC_DS1307::get()
  

 if (! RTC.isrunning()) {
 Serial.println("RTC is NOT running!");      // following line sets the RTC to the date & time this sketch was compiled
  
  RTC.adjust(DateTime(2014,05,19,11,45,0));
  
 }
  
   if(timeStatus()!= timeSet)
     Serial.println("Unable to sync with the RTC");
  else
     Serial.println("RTC has set the system time"); 
  
  
   
  Alarm.alarmRepeat(9,0,0, MorningAlarm);     // create a first alarm to do an action every day at the same time
  Alarm.alarmRepeat(20,30,0, EveningAlarm);    // create a second alarm to do an action every day at the same time
}


void  loop(){  
  digitalClockDisplay(); //declare the function digital clock display
  Alarm.delay(1000); // wait one second between clock display (it is necessary to allow the alarms to work properly)
   
}


void MorningAlarm(){         // functions to be called when the first alarm triggers
 
  int BLUELed = 9;          // declare that we have connected the White LEDs to pin 11
 
  for(int fadeValue = 0 ; fadeValue <= 255; fadeValue +=5) { 
    
  analogWrite(BLUELed, fadeValue);         
        
  delay(30000);                  // wait for 1 second to see the dimming effect
 
   Serial.println("LIGHT ON");       // write on the serial port "LIGHT ON"                          
  }
}

void EveningAlarm(){         // functions to be called when the first alarm triggers
 
  int BLUELed = 9;
   
  for(int fadeValue = 255 ; fadeValue >= 0; fadeValue -=5) { 
   
  analogWrite(BLUELed, fadeValue);    
       
  delay(30000);
 
  Serial.println("LIGHT OFF");        // the same as above but with fade out     
     }
}



void digitalClockDisplay()         
{
  DateTime now = RTC.now();
    
    Serial.print(now.year(), DEC);
    Serial.print('/');
    if(now.month() < 10) Serial.print("0");
    Serial.print(now.month(), DEC);
    Serial.print('/');
    if(now.day() < 10) Serial.print("0");
    Serial.print(now.day(), DEC);
    Serial.print(' ');
    if(now.hour() < 10) Serial.print("0");
    Serial.print(now.hour(), DEC);
    Serial.print(':');
    if(now.minute() < 10) Serial.print("0");
    Serial.print(now.minute(), DEC);
    Serial.print(':');
    if(now.second() < 10) Serial.print("0");
    Serial.print(now.second(), DEC);
    Serial.println();
    
    delay(9000);
    
}                            // END


